import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class OTPSettingsPage extends StatefulWidget {
  const OTPSettingsPage({Key? key}) : super(key: key);

  @override
  _OTPSettingsPageState createState() => _OTPSettingsPageState();
}

class _OTPSettingsPageState extends State<OTPSettingsPage> with AppActiveContentMixin {
  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: FormEditorPage(
            heading: 'OTP Settings',
            description:
                'One time password/tokens are to allow user reset their account passwords, verify their emails.',
            items: [
              SettingItem(
                intId: AppSettings.ID_SS_INT_OTP_LIFETIME_IN_TRIES,
                settingKey: AppSettings.KEY_SS_INT_OTP_LIFETIME_IN_TRIES,
                type: FieldType.text,
                leading: 'Maximum number of Attempts',
                placeholder: 'Maximum number of tries',
                description: 'Number of failed attempts that are allowed for a single generated OTP.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_INT_OTP_LIFETIME_IN_HOURS,
                settingKey: AppSettings.KEY_SS_INT_OTP_LIFETIME_IN_HOURS,
                type: FieldType.text,
                leading: 'OTP Lifetime',
                placeholder: 'Lifetime in Hours',
                description: 'OTPs will be considered expired after set amount of hours from generation. (in hours)',
              ),
            ],
          ),
        ),
      ],
    );
  }
}
